/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.attr.AbstractAttrable;
import cn.gtmap.egovplat.core.attr.CompositeAttrable;
import cn.gtmap.egovplat.core.attr.CompositeAttrableEx;
import cn.gtmap.egovplat.core.attr.JSONAttrable;
import cn.gtmap.egovplat.core.attr.MapAttrable;
import cn.gtmap.egovplat.core.bean.Attrable;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class Attrs {
    public static final Attrable EMPTY_ATTRABLE = new AbstractAttrable(){

        @Override
        public <T> T getAttr(String key, Class<T> targetType) {
            return null;
        }

        @Override
        public Collection<String> getAttrKeys() {
            return Collections.emptyList();
        }

        @Override
        public void setAttr(String key, Object value) {
        }

        @Override
        public void removeAttr(String key) {
        }
    };

    public static Attrable newJSONAttrable() {
        return new JSONAttrable();
    }

    public static Attrable newJSONAttrable(JSONObject json) {
        return new JSONAttrable(json);
    }

    public static Attrable newJSONAttrable(Map<String, Object> map) {
        return new JSONAttrable(map);
    }

    public static Attrable newJSONAttrable(Properties properties) {
        return new JSONAttrable(properties);
    }

    public static Attrable newJSONAttrableWithSize(int size) {
        return new JSONAttrable(new JSONObject(size));
    }

    public static Attrable newMapAttrable() {
        return new MapAttrable();
    }

    public static Attrable newMapAttrable(Map<String, String> map) {
        return new MapAttrable(map);
    }

    public static Attrable newMapAttrable(Properties properties) {
        return new MapAttrable(properties);
    }

    public static Attrable newMapAttrableWithSize(int size) {
        return new MapAttrable(new LinkedHashMap<String, String>(size));
    }

    public static Attrable compositeAttrable(Attrable attrable, Attrable parent) {
        return new CompositeAttrable(attrable, parent);
    }

    public static Attrable compositeAttrable(Attrable attr, Attrable ... parents) {
        return new CompositeAttrableEx(attr, parents);
    }

    public static Attrable compositeAttrable(Attrable attr, Collection<Attrable> parents) {
        return new CompositeAttrableEx(attr, parents);
    }

    public static Attrable compositeAttrable(Properties props, Properties parent) {
        return Attrs.compositeAttrable(Attrs.newJSONAttrable(props), Attrs.newJSONAttrable(parent));
    }

    private Attrs() {
    }
}

