/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security.web;

import cn.gtmap.egovplat.core.support.spring.ConfigurableInterceptor;
import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.Sec;
import cn.gtmap.egovplat.security.SecurityContext;
import cn.gtmap.egovplat.security.SessionProvider;
import cn.gtmap.egovplat.security.ex.NoPermissonException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class SecContextInterceptor
extends ConfigurableInterceptor {
    private SessionProvider sessionProvider;
    private String[] needLogins;
    private String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setNeedLogins(String[] needLogins) {
        this.needLogins = needLogins;
    }

    public void setSessionProvider(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    @Override
    public boolean internalPreHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SecurityContext.getContext().setSession(this.sessionProvider.getSession(request, response));
        if (RequestUtils.matchAny(request, this.urlPathHelper, this.pathMatcher, this.needLogins) && Sec.isGuest()) {
            if (this.redirectUrl == null) {
                throw new NoPermissonException("Need login");
            }
            response.sendRedirect(this.redirectUrl + (this.redirectUrl.contains("?") ? "&" : "?") + "url=" + ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).build().encode());
            return false;
        }
        return true;
    }

    @Override
    public void internalAfterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SecurityContext.clearContext();
    }
}

