/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security.impl;

import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.IdentityService;
import cn.gtmap.egovplat.security.Role;
import cn.gtmap.egovplat.security.Session;
import cn.gtmap.egovplat.security.SessionProvider;
import cn.gtmap.egovplat.security.User;
import cn.gtmap.egovplat.security.impl.AbstractSession;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.WebUtils;

public class TokenSsoSessionProvider
implements SessionProvider {
    protected IdentityService identityService;

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    @Override
    public Session getSession(HttpServletRequest request, HttpServletResponse response) {
        return this.getSession(this.getToken(request));
    }

    protected Session getSession(String token) {
        return new AbstractSession(token){
            private static final long serialVersionUID = 5202907618308057498L;

            @Override
            protected String internalGetGlobalToken() {
                return TokenSsoSessionProvider.this.identityService.createGlobalToken(this.getUserId(), null);
            }

            @Override
            protected String internalGetUserId() {
                String userId = TokenSsoSessionProvider.this.identityService.getUserIdByToken(this.getToken());
                return userId;
            }

            @Override
            protected Set<Role> internalGetRoles() {
                return TokenSsoSessionProvider.this.identityService.getUserRoles(this.getUserId());
            }

            @Override
            protected User internalGetUser() {
                return TokenSsoSessionProvider.this.identityService.getUser(this.getUserId());
            }

            @Override
            public String getIp() {
                return this.getAttr("__ip");
            }

            @Override
            public boolean isGuest() {
                return StringUtils.isBlank((CharSequence)this.getUserId());
            }
        };
    }

    protected String getToken(HttpServletRequest request) {
        String token = null;
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"hp_t");
        if (cookie != null) {
            token = cookie.getValue();
        }
        if (token == null) {
            token = RequestUtils.getParameter(request, "hp_t");
        }
        if (token == null) {
            token = request.getHeader("hp_t");
        }
        return StringUtils.trimToNull((String)token);
    }
}

