/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.security.Constants;
import cn.gtmap.egovplat.security.Role;
import cn.gtmap.egovplat.security.SecurityContext;
import cn.gtmap.egovplat.security.Session;
import cn.gtmap.egovplat.security.User;
import cn.gtmap.egovplat.security.impl.SimpleRole;
import java.util.Collection;
import java.util.Set;

public final class Sec {
    public static Session getSession() {
        Session session = SecurityContext.getContext().getSession();
        if (session == null) {
            throw new SecurityException("Session not found");
        }
        return session;
    }

    public static boolean hasSession() {
        return SecurityContext.getContext().getSession() != null;
    }

    public static User getUser() {
        return Sec.getSession().getUser();
    }

    public static String getUserId() {
        return Sec.getSession().getUserId();
    }

    public static String getToken() {
        Session session = SecurityContext.getContext().getSession();
        return session == null ? null : session.getToken();
    }

    public static String getGlobalToken() {
        Session session = SecurityContext.getContext().getSession();
        return session == null ? null : session.getGlobalToken();
    }

    public static Set<Role> getRoles() {
        return Sec.getSession().getRoles();
    }

    public static boolean hasRole(String roleName) {
        return Sec.getRoles().contains(new SimpleRole(roleName));
    }

    public static boolean hasRoles(Collection<String> roleNames) {
        Set<Role> userRoles = Sec.getRoles();
        for (String roleName : roleNames) {
            if (userRoles.contains(new SimpleRole(roleName))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyRoles(Collection<String> roleNames) {
        Set<Role> userRoles = Sec.getRoles();
        for (String roleName : roleNames) {
            if (!userRoles.contains(new SimpleRole(roleName))) continue;
            return true;
        }
        return false;
    }

    public static boolean lacksRole(String roleName) {
        return !Sec.hasRole(roleName);
    }

    public static boolean lacksRoles(Collection<String> roleNames) {
        Set<Role> userRoles = Sec.getRoles();
        for (String roleName : roleNames) {
            if (!userRoles.contains(new SimpleRole(roleName))) continue;
            return false;
        }
        return true;
    }

    public static boolean isGuest() {
        return Sec.getSession().isGuest();
    }

    public static boolean isAdmin() {
        return Sec.getRoles().contains(Constants.ROLE_ADMIN);
    }

    private Sec() {
    }
}

