/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.model.identity;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.core.bean.DictItemable;
import cn.gtmap.egovplat.core.bean.Orderable;
import cn.gtmap.egovplat.core.bean.TreeNode;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import cn.gtmap.egovplat.core.util.TreePathBuilder;
import cn.gtmap.egovplat.model.identity.User;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="pf_department")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Resource(key="Department", name="\u90e8\u95e8\u4fe1\u606f")
public class Department
extends BaseEntity
implements DictItemable,
Orderable,
TreeNode<Department>,
Comparable<Department> {
    private static final long serialVersionUID = -5143133284753258524L;
    @Column(length=256, nullable=false)
    @Field(value="\u540d\u79f0")
    private String name;
    @Column(length=32)
    @Field(value="\u4ee3\u7801")
    private String code;
    @Column(length=256)
    @Field(value="\u8bf4\u660e")
    private String description;
    @Column(precision=5, nullable=false)
    @Field(value="\u6743\u91cd")
    private int weight;
    @Column(length=1024, nullable=false)
    private String path;
    @Column(length=32)
    @Field(value="\u6cd5\u4eba")
    private String owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field(value="\u7236\u90e8\u95e8")
    private Department parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    @OrderBy(value="weight")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field(value="\u5b50\u90e8\u95e8\u5217\u8868")
    private List<Department> children = Lists.newArrayList();
    @ManyToMany(mappedBy="departments")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Field(value="\u7528\u6237\u5217\u8868")
    private Set<User> users = Sets.newHashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @JSONField(serialize=false)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    @JSONField(serialize=false)
    public Department getParent() {
        return this.parent;
    }

    public void setParent(Department parent) {
        this.parent = parent;
    }

    @Override
    @JSONField(serialize=false)
    public List<Department> getChildren() {
        return this.children;
    }

    public void setChildren(List<Department> children) {
        this.children = children;
    }

    @Override
    public Department getChild(int index) {
        if (this.children != null && !this.children.isEmpty() && this.children.size() > index) {
            return this.children.get(index);
        }
        return null;
    }

    @Override
    @JSONField(serialize=false)
    public Department getFirst() {
        return this.getChild(0);
    }

    @Override
    @JSONField(serialize=false)
    public Department getLast() {
        return this.getChild(this.children.size() - 1);
    }

    @Override
    @JSONField(serialize=false)
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    @JSONField(serialize=false)
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean hasChild() {
        return !this.children.isEmpty();
    }

    @JSONField(serialize=false)
    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    @Override
    @JSONField(serialize=false)
    public String getKey() {
        return this.name;
    }

    @Override
    public String getItemKey() {
        return this.getId();
    }

    @Override
    public String getItemValue() {
        return this.getName();
    }

    @Override
    public int compareTo(Department o) {
        return o.getWeight() - this.weight;
    }

    @PrePersist
    public void init() {
        if (this.isNew()) {
            this.setWeight(this.hasChild() ? this.getLast().getWeight() + 1 : 1);
            this.setPath(new TreePathBuilder<Department>(){

                @Override
                protected String getId(Department dept) {
                    return dept.getId();
                }
            }.build(this));
        }
    }
}

