/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.model.auth;

import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.model.auth.PrivilegeKey;
import cn.gtmap.egovplat.security.Operation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@IdClass(value=PrivilegeKey.class)
@Table(name="pf_privilege")
@Resource(key="Privilege", name="\u6388\u6743\u9879")
public class Privilege
extends PrivilegeKey
implements Serializable {
    private static final long serialVersionUID = 4680590785889918655L;
    @Column(nullable=false)
    private long operation;
    @Column(precision=3, nullable=false)
    private int nodeType;

    public Privilege(String roleId, String nodeId, int nodeType, Collection<Operation> operations) {
        super(roleId, nodeId);
        this.operation = Operation.toCode(operations);
        this.nodeType = nodeType;
    }

    public Privilege(String roleId, String nodeId, int nodeType, Operation ... operations) {
        this(roleId, nodeId, nodeType, Arrays.asList(operations));
    }

    public Privilege(String roleId, String nodeId, int nodeType, long operation) {
        super(roleId, nodeId);
        this.operation = operation;
        this.nodeType = nodeType;
    }

    public Privilege() {
    }

    public long getOperation() {
        return this.operation;
    }

    public void setOperation(long operation) {
        this.operation = operation;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public List<Operation> getOperations() {
        return Operation.getOperations(this.getOperation());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

