/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.web;

import cn.gtmap.egovplat.core.i18n.NLS;
import cn.gtmap.egovplat.core.util.ExUtils;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public abstract class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected final String getMsg(String key) {
        return NLS.get(key);
    }

    protected final String getMsg(String key, Object ... args) {
        return NLS.get(key, args);
    }

    protected static void success(RedirectAttributes ra, String msg) {
        ra.addFlashAttribute("ret", (Object)true);
        ra.addFlashAttribute("msg", (Object)msg);
    }

    protected static void success(RedirectAttributes ra) {
        ra.addFlashAttribute("ret", (Object)true);
    }

    protected static void fail(Model model, String msg) {
        model.addAttribute("ret", (Object)false);
        model.addAttribute("msg", (Object)msg);
    }

    protected static void fail(Model model, Exception ex) {
        model.addAttribute("ret", (Object)false);
        model.addAttribute("msg", (Object)ex.getMessage());
    }

    protected static void fail(Model model) {
        model.addAttribute("ret", (Object)false);
    }

    protected static Map<String, Object> success() {
        return Collections.singletonMap("ret", true);
    }

    protected static Map<String, Object> fail(String message) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("ret", false);
        map.put("msg", message);
        return map;
    }

    protected static Map<String, Object> fail(Exception ex) {
        return ExUtils.toMap(ex);
    }
}

