/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.validation.interceptor;

import cn.gtmap.egovplat.core.validation.ValidationException;
import java.lang.reflect.Field;
import java.util.Map;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.exception.OValException;
import net.sf.oval.internal.Log;
import org.apache.commons.lang3.StringUtils;

public class AppExceptionTranslator
implements ExceptionTranslator {
    private static final Log LOG = Log.getLog(AppExceptionTranslator.class);

    public RuntimeException translateException(OValException ex) {
        if (ex instanceof ConstraintsViolatedException) {
            ConstraintsViolatedException cex = (ConstraintsViolatedException)ex;
            ConstraintViolation cv = cex.getConstraintViolations()[0];
            String key = cv.getCheckName();
            OValContext ctx = cv.getContext();
            if (ctx instanceof FieldContext) {
                Field field = ((FieldContext)ctx).getField();
                key = StringUtils.uncapitalize((String)field.getDeclaringClass().getSimpleName()) + "." + field.getName();
            } else if (ctx instanceof ConstructorParameterContext) {
                key = ((ConstructorParameterContext)ctx).getParameterName();
            } else if (ctx instanceof MethodParameterContext) {
                key = ((MethodParameterContext)ctx).getParameterName();
            } else if (ctx instanceof MethodReturnValueContext) {
                key = ((MethodReturnValueContext)ctx).getMethod().getName();
            }
            LOG.info("Validation Exception ctx: {1} error: {2}", (Object)ctx, (Throwable)ex);
            return new ValidationException(key, cv.getMessage(), (Throwable)ex, (Object[])this.getVariables(cv.getMessageVariables()));
        }
        return new ValidationException(ex.getMessage(), ex.getCause());
    }

    private String[] getVariables(Map<String, ?> args) {
        if (args == null) {
            return new String[0];
        }
        String[] arr = new String[args.size()];
        int i = 0;
        for (Object value : args.values()) {
            arr[i++] = String.valueOf(value);
        }
        return arr;
    }
}

