/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.template;

import cn.gtmap.egovplat.core.template.RenderingException;
import cn.gtmap.egovplat.core.template.TemplateNotFoundException;
import cn.gtmap.egovplat.core.template.TemplateRenderer;
import cn.gtmap.egovplat.core.util.Codecs;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class FreemarkerTemplateRenderer
implements TemplateRenderer {
    private static Logger LOG = LoggerFactory.getLogger(FreemarkerTemplateRenderer.class);
    private Configuration configuration;
    private Map<String, Object> variables;
    private Cache<String, Template> templateCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public void setFreeMarkerConfig(FreeMarkerConfig freeMarkerConfig) {
        this.setConfiguration(freeMarkerConfig.getConfiguration());
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    @Override
    public String render(String templateName, Map<String, Object> params) {
        return this.renderTpl(this.getTemplate(templateName), params);
    }

    @Override
    public void render(String templateName, Map<String, Object> params, Writer writer) {
        this.renderTpl(this.getTemplate(templateName), params, writer);
    }

    @Override
    public String renderFragment(String fragment, Map<String, Object> params) throws RenderingException {
        return this.renderTpl(this.getStringTemplate(fragment), params);
    }

    private void renderTpl(Template tpl, Map<String, Object> params, Writer writer) {
        try {
            tpl.process(this.createModel(params), writer);
        }
        catch (Exception e) {
            LOG.error("Render template:[" + tpl + "] error", (Throwable)e);
            throw new RenderingException(e);
        }
    }

    private Map<String, Object> createModel(Map<String, Object> params) {
        if (this.variables != null) {
            HashMap model = Maps.newHashMap(this.variables);
            model.putAll(params);
            return model;
        }
        return params;
    }

    private String renderTpl(Template tpl, Map<String, Object> params) {
        StringWriter writer = new StringWriter();
        this.renderTpl(tpl, params, writer);
        return writer.toString();
    }

    private Template getTemplate(String name) {
        try {
            return this.configuration.getTemplate(name);
        }
        catch (IOException e) {
            throw new TemplateNotFoundException("Tpl [" + name + "] not found", e);
        }
    }

    private Template getStringTemplate(final String content) {
        final String key = Codecs.hash(content);
        try {
            return (Template)this.templateCache.get((Object)key, (Callable)new Callable<Template>(){

                @Override
                public Template call() throws Exception {
                    return new Template(key, content, FreemarkerTemplateRenderer.this.configuration);
                }
            });
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }
}

