/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.wro;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.DefaultWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.util.ObjectFactory;

public class SpringWroFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SpringWroFilter.class);
    private String wroContextPath;
    private FilterConfig filterConfig;
    private WroConfiguration wroConfiguration;
    private WroManagerFactory wroManagerFactory;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        String targetBeanName = config.getInitParameter("targetBeanName");
        if (targetBeanName == null) {
            targetBeanName = "wroConfigurationFactory";
        }
        this.wroContextPath = config.getInitParameter("wroContextPath");
        if (this.wroContextPath == null) {
            this.wroContextPath = "/static/wro";
        }
        this.wroContextPath = config.getServletContext().getContextPath() + this.wroContextPath;
        WebApplicationContext ctx = null;
        try {
            ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        }
        catch (Throwable e) {
            return;
        }
        PropertyWroConfigurationFactory factory = (PropertyWroConfigurationFactory)ctx.getBean(targetBeanName, PropertyWroConfigurationFactory.class);
        if (factory == null) {
            throw new WroRuntimeException("Could not locate: " + PropertyWroConfigurationFactory.class.getName() + " instance in applicationContext with bean name: " + targetBeanName);
        }
        this.wroConfiguration = factory.create();
        this.wroManagerFactory = DefaultWroManagerFactory.create((ObjectFactory)factory);
        new ServletContextAttributeHelper(config.getServletContext()).setManagerFactory(this.wroManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.wroConfiguration == null) {
            chain.doFilter(req, res);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)this.filterConfig), (WroConfiguration)this.wroConfiguration);
            String requestURI = request.getRequestURI();
            if (requestURI.startsWith(this.wroContextPath) && request.getAttribute(WroFilter.ATTRIBUTE_PASSED_THROUGH_FILTER) == null && request.getAttribute(DispatcherStreamLocator.ATTRIBUTE_INCLUDED_BY_DISPATCHER) == null) {
                LOG.trace("processing wro request: {}", (Object)request.getRequestURI());
                try {
                    request.setAttribute(WroFilter.ATTRIBUTE_PASSED_THROUGH_FILTER, (Object)Boolean.TRUE);
                    ((WroManager)this.wroManagerFactory.create()).process();
                }
                catch (Exception e) {
                    LOG.debug("Wro process error occured", (Throwable)e);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            Context.unset();
        }
    }

    public void destroy() {
        if (this.wroManagerFactory != null) {
            this.wroManagerFactory.destroy();
        }
        if (this.wroConfiguration != null) {
            this.wroConfiguration.destroy();
        }
        Context.destroy();
    }
}

