/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.wro;

import cn.gtmap.egovplat.core.util.Codecs;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheStrategy;

public class FsAndMemoryCacheStrategy<K, V>
implements CacheStrategy<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(FsAndMemoryCacheStrategy.class);
    private final Map<K, Optional<V>> map = Maps.newConcurrentMap();
    private final File tmpPath = new File(System.getProperty("java.io.tmpdir"), "wro-" + Codecs.hash(System.getProperty("user.dir"), 6));

    public FsAndMemoryCacheStrategy() {
        if (!this.tmpPath.exists()) {
            this.tmpPath.mkdirs();
        } else if (this.tmpPath.list().length > 1000) {
            this.clear();
        }
    }

    public void put(K key, V value) {
        this.map.put(key, Optional.fromNullable(value));
        if (value != null) {
            try {
                FileUtils.writeByteArrayToFile((File)new File(this.tmpPath, this.getStringKey(key)), (byte[])SerializationUtils.serialize((Serializable)((Serializable)value)));
            }
            catch (IOException e) {
                LOG.warn("Error to store [" + key + "=" + value + "]", (Throwable)e);
            }
        }
    }

    public V get(K key) {
        Optional<V> optional = this.map.get(key);
        if (optional != null && optional.isPresent()) {
            return (V)optional.get();
        }
        File file = new File(this.tmpPath, this.getStringKey(key));
        try {
            if (file.exists()) {
                Object value = SerializationUtils.deserialize((byte[])FileUtils.readFileToByteArray((File)file));
                this.map.put(key, Optional.of((Object)value));
                return (V)value;
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return null;
    }

    public void clear() {
        try {
            FileUtils.cleanDirectory((File)this.tmpPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void destroy() {
    }

    private String getStringKey(K key) {
        return Codecs.hash(StringUtils.substringAfter((String)key.toString(), (String)"["));
    }
}

