/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.spring;

import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.ex.Source;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import cn.gtmap.egovplat.core.ex.Sourceable;
import cn.gtmap.egovplat.core.ex.impl.SpringConfSourceExtractor;
import cn.gtmap.egovplat.core.support.spring.FriendlyExceptionRenderInterceptor;
import cn.gtmap.egovplat.core.util.Charsets;
import cn.gtmap.egovplat.core.util.ExUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;

public class AppFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(FriendlyExceptionRenderInterceptor.class);
    public static final String EX_RENDERED = "AppFilter.exRendered";
    private static final String FILTERED = "AppFilter.filtered";
    private ServletContext servletContext;
    private Configuration configuration;
    private List<SourceExtractor> sourceExtractors = Lists.newArrayList();

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        this.configuration = new Configuration();
        this.configuration.setLocalizedLookup(false);
        this.configuration.setDefaultEncoding(Charsets.UTF8);
        this.configuration.setTemplateLoader((TemplateLoader)new WebappTemplateLoader(this.servletContext, "/WEB-INF/views/common"));
        this.sourceExtractors.add(new SpringConfSourceExtractor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(FILTERED) != null) {
            chain.doFilter(request, response);
            return;
        }
        try {
            request.setAttribute(FILTERED, (Object)Boolean.TRUE);
            request.setCharacterEncoding(Charsets.UTF8);
            response.setCharacterEncoding(Charsets.UTF8);
            Object attr = this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (attr instanceof Throwable) {
                this.renderException(request, response, (Throwable)attr);
            }
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable e) {
                if (request.getAttribute(EX_RENDERED) != null) {
                    this.renderException(request, response, e);
                }
            }
        }
        finally {
            request.removeAttribute(FILTERED);
        }
    }

    private void renderException(ServletRequest request, ServletResponse response, Throwable ex) throws IOException {
        response.resetBuffer();
        Sourceable sEx = this.findSourceable(ex);
        if (sEx != null) {
            ex = (Throwable)((Object)sEx);
        }
        HashMap model = Maps.newHashMap();
        AppException appEx = ExUtils.wrap(ex);
        model.put("type", ex.getClass());
        model.put("rawEx", ex);
        model.put("ex", appEx);
        if (LOG.isWarnEnabled()) {
            LOG.warn("Handler request exception [" + ((HttpServletRequest)request).getRequestURI() + "],id=" + appEx.getId(), (Throwable)appEx);
        }
        if (Env.isDev()) {
            Source source = ExUtils.extractSource(this.sourceExtractors, ex);
            if (source == null) {
                source = new Source();
                if (sEx != null) {
                    source.setTitle(sEx.getTitle());
                    source.setFile(sEx.getFile());
                    source.setLineNumber(sEx.getLineNumber());
                    source.setLines(sEx.getLines());
                } else {
                    source.setTitle("Application startup error");
                }
                source.setDescription(ExUtils.buildNestedMessage(ex));
            }
            model.put("source", source);
        }
        try {
            this.configuration.getTemplate((Env.isDev() ? "ex" : "error") + ".ftl").process((Object)model, (Writer)response.getWriter());
        }
        catch (TemplateException e) {
            ExUtils.throwEx(e);
        }
    }

    private Sourceable findSourceable(Throwable cause) {
        Throwable lastCause = null;
        while (cause != null && cause != lastCause) {
            if (cause instanceof Sourceable) {
                return (Sourceable)((Object)cause);
            }
            lastCause = cause;
            cause = cause.getCause();
        }
        return null;
    }

    public void destroy() {
    }
}

