/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jpa.HibernateEntityManager;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public final class JPAHelper {
    public static EntityManager getEntityManager(EntityManagerFactory entityManagerFactory) {
        return EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)entityManagerFactory);
    }

    public static SessionFactory getSessionFactory(EntityManagerFactory entityManagerFactory) {
        return ((HibernateEntityManagerFactory)entityManagerFactory).getSessionFactory();
    }

    public static Session getSession(EntityManagerFactory entityManagerFactory) {
        return ((HibernateEntityManager)EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)entityManagerFactory)).getSession();
    }

    public static Session getSession(SessionFactory sessionFactory) {
        return sessionFactory.getCurrentSession();
    }

    public static <T> T getId(SessionFactory sessionFactory, Object entity) {
        ClassMetadata classMetadata = sessionFactory.getClassMetadata(entity.getClass());
        if (classMetadata != null) {
            return (T)classMetadata.getIdentifier(entity, (SessionImplementor)JPAHelper.getSession(sessionFactory));
        }
        return null;
    }

    public static void clearL1Cache(EntityManagerFactory entityManagerFactory) {
        JPAHelper.getSession(entityManagerFactory).clear();
    }

    private JPAHelper() {
    }
}

