/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.freemarker.directive;

import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.support.freemarker.FmUtils;
import cn.gtmap.egovplat.core.util.RequestUtils;
import com.google.common.collect.Lists;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;

public class WroDirective
implements TemplateDirectiveModel,
ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(WroDirective.class);
    public static final String TYPE = "type";
    public static final String EXPLODED = "exploded";
    public static final String MIN = "min";
    public static final String GROUP = "group";
    private ServletContext servletContext;
    private WroManager wroManager;
    private WroModelInspector inspector;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public WroManager getWroManager() {
        if (this.wroManager == null) {
            this.initWro();
        }
        return this.wroManager;
    }

    public WroModelInspector getInspector() {
        if (this.inspector == null) {
            this.initWro();
        }
        return this.inspector;
    }

    private void initWro() {
        ServletContextAttributeHelper helper = new ServletContextAttributeHelper(this.servletContext);
        this.wroManager = (WroManager)helper.getManagerFactory().create();
        this.inspector = new WroModelInspector((WroModel)this.wroManager.getModelFactory().create());
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Object groupObj = FmUtils.getParam(params, GROUP);
        ArrayList groups = Lists.newArrayList();
        if (groupObj instanceof Iterable) {
            for (Object obj : (Iterable)groupObj) {
                Collections.addAll(groups, StringUtils.split((String)obj.toString(), (char)','));
            }
        } else {
            Collections.addAll(groups, StringUtils.split((String)groupObj.toString(), (char)','));
        }
        if (groups.isEmpty()) {
            return;
        }
        String type = FmUtils.getString(params, TYPE);
        boolean minimize = FmUtils.getBoolean(params, MIN, false);
        boolean exploded = FmUtils.getBoolean(params, EXPLODED, true);
        if (Env.isProd()) {
            minimize = true;
            exploded = false;
        }
        StringBuilder jsSb = new StringBuilder();
        StringBuilder cssSb = new StringBuilder();
        for (String s : groups) {
            Group group = this.getInspector().getGroupByName(s.trim());
            if (group != null) {
                String version;
                if (exploded) {
                    for (Resource resource : group.getResources()) {
                        String url = resource.getUri();
                        this.include(resource.getType() == ResourceType.CSS ? cssSb : jsSb, resource.getType(), url, null, null);
                    }
                    continue;
                }
                CacheKey key = new CacheKey(group.getName(), ResourceType.JS, minimize);
                CacheValue cacheValue = (CacheValue)this.getWroManager().getCacheStrategy().get((Object)key);
                String string = version = cacheValue != null ? cacheValue.getHash() : null;
                if ("js".equals(type)) {
                    this.include(jsSb, ResourceType.JS, "/static/wro/" + group.getName() + ".js", version, minimize);
                    continue;
                }
                if ("css".equals(type)) {
                    this.include(cssSb, ResourceType.CSS, "/static/wro/" + group.getName() + ".css", version, minimize);
                    continue;
                }
                this.include(cssSb, ResourceType.CSS, "/static/wro/" + group.getName() + ".css", version, minimize);
                this.include(jsSb, ResourceType.JS, "/static/wro/" + group.getName() + ".js", version, minimize);
                continue;
            }
            LOG.info("Wro group [{}] not found", (Object)s);
        }
        if (cssSb.length() > 0) {
            env.getOut().write(cssSb.toString());
        }
        if (jsSb.length() > 0) {
            env.getOut().write(jsSb.toString());
        }
    }

    private void include(StringBuilder sb, ResourceType type, String url, String version, Boolean minimize) {
        sb.append(type == ResourceType.CSS ? "<link href=\"" : "<script src=\"");
        sb.append(RequestUtils.buildUrl(url, null));
        if (minimize != null) {
            if (minimize.booleanValue()) {
                if (version != null) {
                    sb.append("?").append(StringUtils.left((String)version, (int)8));
                }
            } else {
                sb.append("?minimize=false");
                if (version != null) {
                    sb.append("&").append(StringUtils.left((String)version, (int)8));
                }
            }
        }
        sb.append(type == ResourceType.CSS ? "\" media=\"all\" rel=\"stylesheet\" type=\"text/css\"/>\n" : "\" type=\"text/javascript\"></script>\n");
    }
}

