/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.ex.impl;

import cn.gtmap.egovplat.core.ex.Source;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import cn.gtmap.egovplat.core.util.Charsets;
import cn.gtmap.egovplat.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;

public class SpringConfSourceExtractor
implements SourceExtractor<BeansException> {
    private String[] confPaths = new String[]{"src/main/resources"};

    public void setConfPaths(String[] confPaths) {
        this.confPaths = confPaths;
    }

    @Override
    public boolean isSupport(Throwable ex) {
        return ex instanceof BeansException;
    }

    @Override
    public Source extract(BeansException ex) {
        Source source = new Source();
        source.setTitle("Spring context error");
        ExInfo exInfo = this.getExInfo((Throwable)ex);
        if (exInfo.ex != null) {
            String beanName = exInfo.beanName;
            if (beanName != null) {
                int pos = beanName.lastIndexOf("#");
                beanName = pos > 0 ? "class=\"" + beanName.substring(0, pos) + "\"" : "id=\"" + beanName + "\"";
            }
            this.readLines(source, exInfo.path);
            if (exInfo.line > 0) {
                source.setLineNumber(exInfo.line);
            } else {
                int len = source.getLines().size();
                for (int i = 0; i < len; ++i) {
                    String line = source.getLines().get(i);
                    if (!line.contains(beanName)) continue;
                    source.setLineNumber(i + 1);
                }
            }
            source.setDescription(exInfo.ex.getMessage());
            return source;
        }
        return null;
    }

    private ExInfo getExInfo(Throwable ex) {
        ExInfo exInfo = new ExInfo();
        while (ex != null) {
            String desc;
            BeanCreationException e;
            if (ex instanceof BeanCreationException) {
                e = (BeanCreationException)ex;
                desc = e.getResourceDescription();
                if (StringUtils.contains((CharSequence)desc, (CharSequence)".xml]")) {
                    exInfo.ex = e;
                    exInfo.beanName = e.getBeanName();
                    exInfo.path = SpringConfSourceExtractor.getPath(desc);
                }
            } else if (ex instanceof CannotLoadBeanClassException) {
                e = (CannotLoadBeanClassException)ex;
                desc = e.getResourceDescription();
                if (StringUtils.contains((CharSequence)desc, (CharSequence)".xml]")) {
                    exInfo.ex = e;
                    exInfo.beanName = e.getBeanName();
                    exInfo.path = SpringConfSourceExtractor.getPath(desc);
                }
            } else if (ex instanceof XmlBeanDefinitionStoreException) {
                e = (XmlBeanDefinitionStoreException)ex;
                exInfo.ex = e;
                exInfo.path = SpringConfSourceExtractor.getPath(e.getResourceDescription());
                exInfo.line = e.getLineNumber();
            }
            ex = ex.getCause();
        }
        return exInfo;
    }

    private static String getPath(String desc) {
        return StringUtils.substringBetween((String)desc, (String)"[", (String)"]");
    }

    private void readLines(Source source, String path) {
        for (String sp : this.confPaths) {
            File file = new File(sp, path);
            if (!file.exists()) continue;
            try {
                source.setFile(file.getPath());
                source.setLines(FileUtils.readLines((File)file, (String)Charsets.UTF8));
                return;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    static class ExInfo {
        String beanName;
        String path;
        int line;
        Exception ex;

        ExInfo() {
        }
    }
}

