/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.ex.impl;

import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.ex.Source;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class FreemarkerSourceExtractor
implements SourceExtractor<TemplateException> {
    private static Method GET_ELEMENT_METHOD;
    private static Method GET_DESCRIPTION_METHOD;
    private static Field LINES_FIELD;

    @Override
    public boolean isSupport(Throwable ex) {
        return ex instanceof TemplateException;
    }

    @Override
    public Source extract(TemplateException ex) {
        Environment env = ex.getEnvironment();
        try {
            TemplateElement te = (TemplateElement)GET_ELEMENT_METHOD.invoke((Object)ex, new Object[0]);
            if (te != null) {
                Source source = new Source();
                source.setTitle("Freemarker template error");
                source.setDescription((String)GET_DESCRIPTION_METHOD.invoke((Object)ex, new Object[0]));
                source.setLineNumber(te.getBeginLine());
                source.setColumNumber(te.getBeginColumn());
                Template template = env.getTemplate();
                source.setLines((List)LINES_FIELD.get(template));
                source.setFile(template.getName());
                return source;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            GET_ELEMENT_METHOD = TemplateException.class.getDeclaredMethod("getFailingInstruction", new Class[0]);
            GET_ELEMENT_METHOD.setAccessible(true);
            GET_DESCRIPTION_METHOD = TemplateException.class.getDeclaredMethod("getDescription", new Class[0]);
            GET_DESCRIPTION_METHOD.setAccessible(true);
            LINES_FIELD = Template.class.getDeclaredField("lines");
            LINES_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new AppException("Init error", e);
        }
    }
}

