/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.ex.impl;

import cn.gtmap.egovplat.core.ex.Source;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import cn.gtmap.egovplat.core.util.Charsets;
import cn.gtmap.egovplat.core.util.ExUtils;
import cn.gtmap.egovplat.core.util.FileUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public class DefaultSourceExtractor
implements SourceExtractor<Throwable> {
    private String appPackage;
    private Set<String> excludeClasses = Sets.newHashSet();
    private String[] sourcePaths = new String[]{"src/main/java", "../common/src/main/java"};

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public void setExcludeClasses(Set<String> excludeClasses) {
        this.excludeClasses.addAll(excludeClasses);
    }

    public void setSourcePaths(String[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    @Override
    public boolean isSupport(Throwable ex) {
        return true;
    }

    @Override
    public Source extract(Throwable ex) {
        Source source = new Source();
        StackTraceElement trace = null;
        for (StackTraceElement ste : ex.getStackTrace()) {
            String name = ste.getClassName();
            if (trace == null) {
                trace = ste;
            }
            if (this.excludeClasses.contains(name) || !name.startsWith(this.appPackage)) continue;
            trace = ste;
            break;
        }
        if (trace != null) {
            source.setFile(trace.getFileName());
            source.setLineNumber(trace.getLineNumber());
            source.setTitle("Java exception");
            this.readLines(source, trace);
        }
        source.setDescription(ExUtils.buildNestedMessage(ex));
        return source;
    }

    private void readLines(Source source, StackTraceElement trace) {
        block8: {
            String path = StringUtils.replace((String)trace.getClassName(), (String)".", (String)"/") + ".java";
            for (String sp : this.sourcePaths) {
                File file = new File(sp, path);
                if (!file.exists()) continue;
                try {
                    source.setFile(file.getPath());
                    source.setLines(FileUtils.readLines((File)file, (String)Charsets.UTF8));
                    return;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            try {
                Class clazz = ClassUtils.forName((String)trace.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                String jarPath = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
                String sourcePath = StringUtils.substringBeforeLast((String)jarPath, (String)".") + "-sources.jar";
                File sourceFile = ResourceUtils.getFile((String)sourcePath);
                if (!sourceFile.exists()) break block8;
                try {
                    ZipFile zf = new ZipFile(sourceFile);
                    ZipEntry ze = zf.getEntry(path);
                    if (ze != null) {
                        source.setFile(path);
                        source.setLines(IOUtils.readLines((InputStream)zf.getInputStream(ze), (String)Charsets.UTF8));
                    }
                }
                catch (IOException ignored) {}
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }
}

