/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.env;

import cn.gtmap.egovplat.core.Constants;
import cn.gtmap.egovplat.core.attr.Attrs;
import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.util.IO;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class EnvConfLoader {
    protected final Log logger = LogFactory.getLog(EnvConfLoader.class);
    public static final String HOME = "hp.home";
    public static final String HOME_FOLDER = "hp-home";
    public static final String CONFIG_FILE = "hp.properties";

    public static void load(String ... paths) {
        EnvConfLoader cl = new EnvConfLoader();
        cl.loadConfig(paths);
    }

    public void loadConfig(String ... paths) {
        File root = this.determineRootDir(paths);
        this.logger.info((Object)("Use hp-home dir:[" + root + "]"));
        File confFile = new File(root, CONFIG_FILE);
        Properties props = new Properties();
        this.setConfigProperty(props, HOME, root.getAbsolutePath());
        this.setConfigProperty(props, "hp.confFile", confFile.getAbsolutePath());
        this.loadProperties(props, confFile);
        Env.configuration = Attrs.compositeAttrable(props, System.getProperties());
        String ps = Env.get("app.profiles");
        if (!confFile.exists()) {
            this.logger.info((Object)("Hp config file [" + confFile.getAbsolutePath() + "] not found,enable install mode"));
            ps = ps == null ? "install" : ps + ",install";
        }
        if (ps == null) {
            ps = "default";
        }
        if (System.getProperty("prod") != null) {
            ps = ps + ",prod";
        }
        Env.setAttr("app.profiles", ps);
        System.setProperty("spring.profiles.active", ps);
        this.logger.info((Object)("Use App profiles [" + ps + "]"));
        Env.profiles = StringUtils.commaDelimitedListToSet((String)ps);
        Env.mode = Env.profiles.contains(Env.Mode.PROD.getTitle()) ? Env.Mode.PROD : (Env.profiles.contains(Env.Mode.TEST.getTitle()) ? Env.Mode.TEST : Env.Mode.DEV);
        this.setConfigProperty(props, "app.model", Env.mode.getTitle());
        this.logger.info((Object)("Use App mode     [" + Env.mode.getTitle() + "]"));
    }

    private void loadProperties(Properties p, File file) {
        try {
            if (!file.exists()) {
                return;
            }
            Properties props = IO.readProperties(file);
            for (String name : props.stringPropertyNames()) {
                this.setConfigProperty(p, name, Constants.PLACEHOLDER_HELPER.replacePlaceholders(props.getProperty(name), props));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("error to load props file:[" + file.getAbsolutePath() + "]"), (Throwable)e);
        }
    }

    protected void setConfigProperty(Properties props, String key, String value) {
        props.put(key, value);
        this.logger.debug((Object)("Set env property [" + key + "=" + value + "]"));
    }

    private File determineRootDir(String ... paths) {
        File root;
        if (paths != null) {
            for (String path : paths) {
                root = new File(path);
                if (!root.exists()) continue;
                return root;
            }
        }
        for (String path : new String[]{System.getProperty(HOME), System.getenv("HP_HOME")}) {
            if (path == null || !(root = new File(path)).exists()) continue;
            return root;
        }
        URL url = this.getClass().getResource("/hp-init.properties");
        if (url != null) {
            try {
                String path = IO.readProperties(url.openStream()).getProperty(HOME);
                if (path != null) {
                    path = new File(path).getAbsolutePath();
                    this.logger.info((Object)("Custom config home not found,Use classpath config home dir [" + path + "]"));
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        for (String path : new String[]{System.getProperty("catalina.base"), System.getProperty("catalina.home"), "/opt"}) {
            if (path == null || !(root = new File(path, HOME_FOLDER)).exists()) continue;
            return root;
        }
        root = new File(System.getProperty("user.home"), HOME_FOLDER);
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }
}

