/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.env;

import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.env.EnvConfLoader;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.beans.CachedIntrospectionResults;

public class ContextLoaderListener
extends org.springframework.web.context.ContextLoaderListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        EnvConfLoader.load(new String[0]);
        if (!Env.has("app.url")) {
            Env.setAttr("app.url", event.getServletContext().getContextPath());
        }
        SLF4JBridgeHandler.install();
        CachedIntrospectionResults.acceptClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
        try {
            super.contextInitialized(event);
            Env.started = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        try {
            super.contextDestroyed(event);
        }
        finally {
            Env.started = false;
            SLF4JBridgeHandler.uninstall();
            CachedIntrospectionResults.clearClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }
}

