/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.entity;

import cn.gtmap.egovplat.core.entity.BaseEntity;
import cn.gtmap.egovplat.core.entity.EntityFilter;
import cn.gtmap.egovplat.core.util.DateUtils;
import java.util.Date;
import java.util.List;

public class BaseEntityFilter<E extends BaseEntity>
implements EntityFilter<E> {
    @Override
    public boolean accept(Class<?> clazz) {
        return BaseEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public <S extends E> S prepare(S entity) {
        return entity;
    }

    @Override
    public List<E> prepare(List<E> entities) {
        return entities;
    }

    @Override
    public E beforeSave(E entity) {
        if (((BaseEntity)entity).isNew()) {
            ((BaseEntity)entity).setId(null);
            Date now = DateUtils.now();
            ((BaseEntity)entity).setCreateAt(now);
            ((BaseEntity)entity).setUpdateAt(now);
        }
        return entity;
    }

    @Override
    public E afterSave(E entity) {
        return entity;
    }

    @Override
    public E beforeDelete(E entity) {
        ((BaseEntity)entity).setUpdateAt(new Date());
        return entity;
    }

    @Override
    public E afterDelete(E entity) {
        return entity;
    }
}

