/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.data;

import cn.gtmap.egovplat.core.data.Order;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.mysema.query.types.OrderSpecifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PageRequest
implements Pageable,
Serializable {
    private static final long serialVersionUID = 4668590265538872363L;
    private final int offset;
    private final int size;
    private final Collection<Order> orders;

    public PageRequest(int offset, int size, Collection<Order> orders) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be less than zero!");
        }
        this.offset = offset;
        this.size = size;
        this.orders = orders;
    }

    public PageRequest(int offset, int size, Order ... orders) {
        this(offset, size, ArrayUtils.asList(orders));
    }

    public PageRequest(int offset, int size) {
        this(offset, size, Collections.emptyList());
    }

    public PageRequest(int offset) {
        this(offset, 20);
    }

    public PageRequest() {
        this(0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @JSONField(serialize=false)
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getIndex() {
        return PageRequest.toIndex(this.offset, this.size);
    }

    @Override
    public Collection<Order> getOrders() {
        return this.orders;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.offset;
        result = 31 * result + this.size;
        result = 31 * result + ((Object)this.orders).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Pageable)) {
            return false;
        }
        Pageable other = (Pageable)obj;
        return this.offset == other.getOffset() && this.size == other.getSize() && ((Object)this.orders).equals(other.getOrders());
    }

    public String toString() {
        return "offset:" + this.offset + ", size:" + this.size + (this.orders.isEmpty() ? "" : ", orders:" + this.orders.toString());
    }

    @Override
    public Pageable next() {
        return new PageRequest(this.offset + this.size, this.size, this.orders);
    }

    @Override
    public Pageable previous() {
        return new PageRequest(this.offset - this.size, this.size, this.orders);
    }

    @Override
    public Pageable order(Order order) {
        ArrayList orders = Lists.newArrayList(this.orders);
        orders.add(order);
        return new PageRequest(this.offset, this.size, orders);
    }

    @Override
    public Pageable order(OrderSpecifier order) {
        ArrayList orders = Lists.newArrayList(this.orders);
        orders.add(Order.order(order));
        return new PageRequest(this.offset, this.size, orders);
    }

    public static int toOffset(int index, int size) {
        return (index - 1) * size;
    }

    public static int toIndex(int offset, int size) {
        return offset / size + 1;
    }
}

