/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.data;

import cn.gtmap.egovplat.core.data.Order;
import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.PageRequest;
import cn.gtmap.egovplat.core.data.Pageable;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.mysema.query.types.OrderSpecifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PageImpl<T>
implements Page<T>,
Serializable {
    private static final long serialVersionUID = 1831642480676287957L;
    public static final Pageable NULL = new PageRequest(0, Integer.MAX_VALUE);
    public static final int SHOW_PAGES = 12;
    private final Pageable pageable;
    private final long total;
    private final List<T> items;

    public PageImpl(List<T> items, long total, Pageable pageable) {
        this.items = items == null ? Collections.emptyList() : items;
        this.total = total;
        this.pageable = pageable;
    }

    public PageImpl(List<T> items) {
        this(items, items == null ? 0L : (long)items.size(), NULL);
    }

    public PageImpl() {
        this(Collections.emptyList());
    }

    @Override
    public long getTotalCount() {
        return this.total;
    }

    @Override
    @JSONField(serialize=false)
    public int getPageCount() {
        if (this.getSize() < 0) {
            return 0;
        }
        int count = (int)(this.total / (long)this.getSize());
        return this.total % (long)this.getSize() != 0L ? count + 1 : count;
    }

    @Override
    @JSONField(serialize=false)
    public int getItemSize() {
        return this.items.size();
    }

    @Override
    public List<T> getItems() {
        return this.items;
    }

    @Override
    public T getItem(int index) {
        return this.items.get(index);
    }

    @Override
    @JSONField(serialize=false)
    public T getFirst() {
        return this.items.get(0);
    }

    @Override
    @JSONField(serialize=false)
    public T getLast() {
        return this.items.get(this.items.size() - 1);
    }

    @Override
    @JSONField(serialize=false)
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    @JSONField(serialize=false)
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    @JSONField(serialize=false)
    public boolean hasPrevious() {
        return !this.isFirst();
    }

    @Override
    @JSONField(serialize=false)
    public boolean hasNext() {
        return !this.isLast();
    }

    @Override
    @JSONField(serialize=false)
    public boolean isFirst() {
        return this.getIndex() == 1;
    }

    @Override
    @JSONField(serialize=false)
    public boolean isLast() {
        return this.getIndex() >= this.getPageCount();
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    @JSONField(serialize=false)
    public int getSize() {
        return this.pageable.getSize();
    }

    @Override
    @JSONField(serialize=false)
    public int getOffset() {
        return this.pageable.getOffset();
    }

    @Override
    @JSONField(serialize=false)
    public int getIndex() {
        return this.pageable.getIndex();
    }

    @Override
    @JSONField(serialize=false)
    public Collection<Order> getOrders() {
        return this.pageable.getOrders();
    }

    @Override
    public Pageable next() {
        return this.pageable.next();
    }

    @Override
    public Pageable previous() {
        return this.pageable.previous();
    }

    @Override
    public Pageable order(Order order) {
        return this.pageable.order(order);
    }

    @Override
    public Pageable order(OrderSpecifier order) {
        return this.pageable.order(order);
    }

    @Override
    @JSONField(serialize=false)
    public List<Integer> getShowIndexs() {
        int end;
        int start;
        ArrayList indexs = Lists.newArrayListWithCapacity((int)32);
        int index = this.getIndex();
        int total = this.getPageCount();
        if (total <= 12) {
            start = 1;
            end = total;
        } else {
            start = index + 1 - 4;
            end = index + 1 + 8;
            if (end > total) {
                end = total;
                start = total - 12;
            } else if (start <= 0) {
                start = 1;
                end = 12;
            }
        }
        for (int i = start; i < end; ++i) {
            indexs.add(i);
        }
        return indexs;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        result = 31 * result + this.pageable.hashCode();
        result = 31 * result + ((Object)this.items).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        return this.total == other.getTotalCount() && ((Object)this.items).equals(other.getItems()) && this.pageable.equals(this);
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.isNotEmpty()) {
            contentType = this.getFirst().getClass().getName();
        }
        return "Page " + this.getIndex() + "/" + this.getPageCount() + " containing [" + contentType + "] instances";
    }
}

