/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.data;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Order
implements Serializable {
    private static final long serialVersionUID = 6285805100711077135L;
    public static final Direction DEFAULT_DIRECTION = Direction.DESC;
    private final String field;
    private final Direction direction;

    public Order(String field, Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    public String getField() {
        return this.field;
    }

    @JSONField(serialize=false)
    public Direction getDirection() {
        return this.direction;
    }

    public boolean isAsc() {
        return this.direction.isAsc();
    }

    public static Order order(String field, Direction direction) {
        return new Order(field, direction);
    }

    public static Order order(String field, boolean asc) {
        return Order.order(field, asc ? Direction.ASC : Direction.DESC);
    }

    public static Order order(String field) {
        return Order.order(field, DEFAULT_DIRECTION);
    }

    public static Order order(OrderSpecifier order) {
        return Order.order(((Path)order.getTarget()).getMetadata().getName(), order.isAscending());
    }

    public static Order asc(String field) {
        return Order.order(field, true);
    }

    public static Order desc(String field) {
        return Order.order(field, false);
    }

    public static List<Order> orders(boolean asc, Collection<String> fields) {
        ArrayList orders = Lists.newArrayListWithCapacity((int)fields.size());
        for (String field : fields) {
            orders.add(Order.order(field, asc));
        }
        return orders;
    }

    public static List<Order> orders(boolean asc, String ... fields) {
        if (fields == null) {
            return Collections.emptyList();
        }
        return Order.orders(asc, Arrays.asList(fields));
    }

    public static List<Order> orders(Collection<String> fields) {
        return Order.orders(DEFAULT_DIRECTION.isAsc(), fields);
    }

    public static List<Order> orders(String ... fields) {
        return Order.orders(DEFAULT_DIRECTION.isAsc(), fields);
    }

    public static List<Order> orders(OrderSpecifier ... orders) {
        if (orders == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (OrderSpecifier os : orders) {
            list.add(Order.order(os));
        }
        return list;
    }

    public int hashCode() {
        return this.field.hashCode() << 1 | this.direction.ordinal();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return this.direction == other.direction && this.field.equals(other.field);
    }

    public String toString() {
        return this.field + " " + this.direction.getValue();
    }

    public static enum Direction {
        ASC("asc"),
        DESC("desc");

        private String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isAsc() {
            return this == ASC;
        }
    }
}

