/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.Constants;
import cn.gtmap.egovplat.core.bean.Attrable;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import cn.gtmap.egovplat.core.util.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class AbstractAttrable
implements Attrable {
    @Override
    public boolean isAttrsEmpty() {
        return this.getAttrKeys().size() == 0;
    }

    @Override
    public boolean hasAttr(String key) {
        return this.getAttr(key) != null;
    }

    @Override
    public String getAttr(String key) {
        return this.getAttr(key, String.class);
    }

    @Override
    public String getAttr(String key, String defaultValue) {
        String value = this.getAttr(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public String getRequiredAttr(String key) throws IllegalStateException {
        String value = this.getAttr(key);
        if (value == null) {
            throw new IllegalStateException("required key [" + key + "] not found");
        }
        return value;
    }

    @Override
    public String getExprAttr(String text) throws IllegalStateException {
        return Constants.PLACEHOLDER_HELPER.replacePlaceholders(text, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                return AbstractAttrable.this.getAttr(placeholderName);
            }
        });
    }

    @Override
    public boolean getBoolAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? false : TypeUtils.castToBoolean((Object)value);
    }

    @Override
    public byte getByteAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? (byte)0 : TypeUtils.castToByte((Object)value);
    }

    @Override
    public short getShortAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? (short)0 : TypeUtils.castToShort((Object)value);
    }

    @Override
    public int getIntAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? 0 : TypeUtils.castToInt((Object)value);
    }

    @Override
    public long getLongAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? 0L : TypeUtils.castToLong((Object)value);
    }

    @Override
    public float getFloatAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? 0.0f : TypeUtils.castToFloat((Object)value).floatValue();
    }

    @Override
    public double getDoubleAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? 0.0 : TypeUtils.castToDouble((Object)value);
    }

    @Override
    public byte[] getBytesAttr(String key) {
        String value = this.getAttr(key);
        return StringUtils.isEmpty((CharSequence)value) ? ArrayUtils.EMPTY_BYTE_ARRAY : TypeUtils.castToBytes((Object)value);
    }

    @Override
    public Date getDateAttr(String key) {
        String value = this.getAttr(key);
        return TypeUtils.castToDate((Object)value);
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType, T defaultValue) {
        T value = this.getAttr(key, targetType);
        return value == null ? defaultValue : value;
    }

    @Override
    public <T> T getRequiredAttr(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getAttr(key, targetType);
        if (value == null) {
            throw new IllegalStateException("required key [" + key + "] not found");
        }
        return value;
    }

    @Override
    public <T> T getAttr(String key, TypeReference<T> targetType) {
        return this.getAttr(key, targetType.getType());
    }

    @Override
    public <T> T getAttr(String key, TypeReference<T> targetType, T defaultValue) {
        return this.getAttr(key, targetType.getType(), defaultValue);
    }

    @Override
    public <T> T getRequiredAttr(String key, TypeReference<T> targetType) throws IllegalStateException {
        return this.getRequiredAttr(key, targetType.getType());
    }

    @Override
    public String[] getArrayAttr(String key) {
        return this.getAttr(key, String[].class);
    }

    @Override
    @JSONField(serialize=false)
    public Map<String, String> getAttrs() {
        return this.getAttrs(Collections.<String>emptyList());
    }

    @Override
    public Map<String, String> getAttrs(String ... keys) {
        return this.getAttrs(ArrayUtils.asList(keys));
    }

    @Override
    public Map<String, String> getAttrs(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            keys = this.getAttrKeys();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (String key : keys) {
            String value = this.getAttr(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.setAttr(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removeAttrs(String ... keys) {
        this.removeAttrs(ArrayUtils.asList(keys));
    }

    @Override
    public void removeAttrs(Collection<String> keys) {
        for (String key : keys) {
            this.removeAttr(key);
        }
    }

    @Override
    public void clearAttrs() {
        this.removeAttrs(Lists.newArrayList(this.getAttrKeys()));
    }

    public String toString() {
        return this.getAttrs().toString();
    }
}

