/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     RoleService.java
 * Modifier: yangxin
 * Modified: 2014-06-12 21:36
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import cn.gtmap.egovplat.model.identity.Role;
import com.mysema.query.types.Predicate;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 角色管理服务.
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-12
 */
public interface RoleService {

    /**
     * 根据id获取角色
     *
     * @param id 主键
     * @return 角色
     */
    Role getRole(String id) throws EntityNotFoundException;

    /**
     * 根据id批量获取角色
     *
     * @param ids id列表
     * @return 角色map, key为角色id, value为角色
     */
    Map<String, Role> mgetRoles(Collection<String> ids);

    /**
     * 根据角色名获取角色
     *
     * @param name 角色名
     * @return 角色
     */
    Role getRoleByName(String name);

    /**
     * 查找角色
     *
     * @param predicate 组合条件
     * @param request   分页参数
     * @return 角色分页对象
     */
    Page<Role> findRole(Predicate predicate, Pageable request);

    /**
     * 保存角色
     *
     * @param role 角色
     * @return 角色
     */
    Role saveRole(Role role);

    /**
     * 删除多个角色
     *
     * @param ids 角色id列表
     */
    void removeRole(Collection<String> ids);

    /**
     * 根据角色名分页查询角色
     * li ning
     *
     * @param roleName
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public List<Role> searchRoleByRoleName(String roleName, int pageIndex, int pageSize);

    /**
     * 根据角色名查询角色记录个数
     * li ning
     *
     * @param roleName
     * @return
     */
    public int getRoleCountByRoleName(String roleName);

    /**
     * 根据角色名查询角色
     * li ning
     *
     * @param roleName
     * @return
     */
    public List<Role> searchRoleByRoleName(String roleName);

    /**
     * 修改角色
     * li ning
     *
     * @param role
     * @return
     */
    public Role mergeRole(Role role);

    /**
     * 修改角色（角色基本信息，角色关联的用户）
     *
     * @param role
     * @param userIds
     */
    public void updateRole(Role role, List<String> userIds);

    /**
     * 插入角色（角色基本信息，角色关联的用户）
     *
     * @param role
     * @param userIds
     */
    public void insertRole(Role role, List<String> userIds);



    /**
     * jl
     *将批量的角色批量赋给多个用户（角色基本信息，角色关联的用户）
     * @param roleIds
     * @param userIds
     */
    public void updateRoles(List<String> roleIds, List<String> userIds);
}