/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DepartmentService.java
 * Modifier: yangxin
 * Modified: 2014-06-12 21:36
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.service;

import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import com.alibaba.fastjson.JSONArray;
import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.model.identity.Department;
import com.mysema.query.types.Predicate;

import java.util.Collection;
import java.util.List;

/**
 * 部门管理服务.
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-12
 */
public interface DepartmentService {

    /**
     * 根据id获取部门
     *
     * @param id 主键
     * @return 部门
     */
    Department getDepartment(String id) throws EntityNotFoundException;

    /**
     * 查找部门
     *
     * @param predicate 组合条件
     * @param request   分页对象
     * @return 部门分页对象
     */
    Page<Department> findDepartment(Predicate predicate, Pageable request);

    /**
     * 获取子部门列表
     *
     * @param id 部门id,为空的话则获取根部门
     * @return 部门列表
     */
    List<Department> getChildrenDepartment(String id);

    /**
     * 获取子部门json列表对象
     *
     * @param id         部门id,为空的话则获取根部门
     * @param fetchLevel 抓取级数,0表示递归抓取所有子部门
     * @return 部门json列表对象
     */
    JSONArray getChildrenDepartmentJSON(String id, int fetchLevel);

    /**
     * 保存部门
     *
     * @param department 部门
     * @return 部门
     */
    Department saveDepartment(Department department);
    Department mergeDepartment(Department department);

    /**
     * 移动一个部门
     *
     * @param id   部门id
     * @param isUp 是否向上移动
     */
    void moveDepartment(String id, boolean isUp);

    /**
     * 批量删除多个部门
     *
     * @param ids 部门id列表
     */
    void removeDepartment(Collection<String> ids);

    /**
     * 根据部门名称查询部门
     * edit by chenjun
     */
    public List<Department> searchDeps(String name);

    public List<Department> searchDepartmentByDepartmentName(String departmentName);
}
