/*
 * Project:  onemap
 * Module:   common
 * File:     SecContextInterceptor.java
 * Modifier: xyang
 * Modified: 2013-05-31 03:25:53
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security.web;

import cn.gtmap.egovplat.core.support.spring.ConfigurableInterceptor;
import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.Sec;
import cn.gtmap.egovplat.security.SecurityContext;
import cn.gtmap.egovplat.security.SessionProvider;
import cn.gtmap.egovplat.security.ex.NoPermissonException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-9-26
 */
public class SecContextInterceptor extends ConfigurableInterceptor {
    private SessionProvider sessionProvider;
    private String[] needLogins;
    private String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setNeedLogins(String[] needLogins) {
        this.needLogins = needLogins;
    }

    public void setSessionProvider(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    @Override
    public boolean internalPreHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SecurityContext.getContext().setSession(sessionProvider.getSession(request, response));
        if (RequestUtils.matchAny(request, urlPathHelper, pathMatcher, needLogins) && Sec.isGuest()) {
            if (redirectUrl != null) {
                response.sendRedirect(redirectUrl + (redirectUrl.contains("?") ? "&" : "?") + "url=" + ServletUriComponentsBuilder.fromRequest(request).build().encode());
            } else {
                throw new NoPermissonException("Need login");
            }
            return false;
        }
        return true;
    }

    @Override
    public void internalAfterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SecurityContext.clearContext();
    }
}
