/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     SimpleRole.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security.impl;


import cn.gtmap.egovplat.security.Role;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-30
 */
public final class SimpleRole implements Role {
    private static final long serialVersionUID = 1836387973187759269L;
    private String id;
    private final String name;
    private transient Integer hash;

    public SimpleRole(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public SimpleRole(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Role && name.equals(((Role) obj).getName());
    }

    @Override
    public int hashCode() {
        if (hash == null) {
            hash = name.hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        return "Role [" + id + "," + name + "]";
    }
}
