/*
 * Project:  onemap
 * Module:   common
 * File:     AbstractSession.java
 * Modifier: xyang
 * Modified: 2013-05-30 05:35:07
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security.impl;

import cn.gtmap.egovplat.core.attr.JSONAttrable;
import cn.gtmap.egovplat.security.Role;
import cn.gtmap.egovplat.security.Session;
import cn.gtmap.egovplat.security.User;

import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 13-5-30
 */
public abstract class AbstractSession extends JSONAttrable implements Session {
    private static final long serialVersionUID = -1505702232205092673L;
    private final String token;
    private String globalToken;
    private String userId;
    private Set<Role> roles;
    private User user;

    public AbstractSession(String token) {
        this.token = token;
    }

    @Override
    public String getToken() {
        return token;
    }

    @Override
    public String getGlobalToken() {
        if (globalToken == null) {
            globalToken = internalGetGlobalToken();
        }
        return globalToken;
    }

    @Override
    public String getUserId() {
        if (userId == null) {
            userId = internalGetUserId();
        }
        return userId;
    }

    @Override
    public Set<Role> getRoles() {
        if (roles == null) {
            roles = internalGetRoles();
        }
        return roles;
    }

    @Override
    public User getUser() {
        if (user == null) {
            user = internalGetUser();
        }
        return user;
    }

    protected abstract String internalGetGlobalToken();

    protected abstract String internalGetUserId();

    protected abstract Set<Role> internalGetRoles();

    protected abstract User internalGetUser();

    @Override
    public int hashCode() {
        return token.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Session && token.equals(((Session) obj).getToken());
    }

    @Override
    public String toString() {
        return "[Session token:" + token + "]";
    }
}
