package cn.gtmap.egovplat.security.impl;

import cn.gtmap.egovplat.security.Constants;
import cn.gtmap.egovplat.security.IdentityService;
import cn.gtmap.egovplat.security.Role;
import com.google.common.collect.Sets;

import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-21
 */
public abstract class AbstractIdentityService implements IdentityService {

    @Override
    public Set<Role> getUserRoles(String userId) {
        Set<Role> roles = Sets.newHashSet();
        roles.add(Constants.ROLE_EVERYONE);
        if (Constants.USER_ADMIN_ID.equals(userId)) {
            roles.add(Constants.ROLE_ADMIN);
            return roles;
        }
        roles.addAll(internalGetUserRoles(userId));
        return roles;
    }

    protected abstract Set<Role> internalGetUserRoles(String userId);
}
