/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Session.java
 * Modifier: yangxin
 * Modified: 2014-06-11 19:41
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.core.bean.Attrable;

import java.io.Serializable;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-30
 */
public interface Session extends Attrable, Serializable {

    /**
     * 会话token
     */
    String getToken();

    /**
     * 全局会话token
     */
    String getGlobalToken();

    /**
     * 用户id
     */
    String getUserId();

    /**
     * 用户ip
     */
    String getIp();

    /**
     * 用户角色列表
     */
    Set<Role> getRoles();

    /**
     * 用户
     */
    User getUser();

    /**
     * 是否匿名会话
     */
    boolean isGuest();
}
