/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Operation.java
 * Modifier: yangxin
 * Modified: 2014-06-11 21:48
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.core.annotation.Resource;
import com.google.common.collect.Lists;
import cn.gtmap.egovplat.core.bean.Dictable;
import cn.gtmap.egovplat.core.bean.Titleable;
import cn.gtmap.egovplat.core.util.EnumUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
@Resource(key = "Operation", name = "资源操作")
public enum Operation implements Dictable, Titleable {

    NULL("空", 0),
    VIEW("查看", 1),
    EDIT("编辑", 2),
    ADMIN("管理", 2 << 1);

    private String title;
    private int code;

    Operation(String title, int code) {
        this.title = title;
        this.code = code;
    }

    public String getTitle() {
        return title;
    }

    public int getCode() {
        return code;
    }

    public Map<String, String> getItems() {
        return EnumUtils.getDictMap(Operation.class, 1);
    }

    public boolean in(long operations) {
        return (operations & code) != 0;
    }

    public static long toCode(Collection<Operation> operations) {
        long code = 0;
        for (Operation operation : operations) {
            code |= operation.getCode();
        }
        return code;
    }

    public static List<Operation> getOperations(long operations) {
        List<Operation> list = Lists.newArrayList();
        for (Operation op : values()) {
            if (op.in(operations)) {
                list.add(op);
            }
        }
        return list;
    }
}
