/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     IdentityService.java
 * Modifier: yangxin
 * Modified: 2014-06-11 19:26
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.security;

import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-30
 */
public interface IdentityService {

    /**
     * 校验token,如果有效返回userId,否则返回null
     *
     * @param token token
     * @return 用户id
     */
    String getUserIdByToken(String token);

    /**
     * 创建全局回话token
     *
     * @param userId 用户id
     * @param ttl    有效期(秒)
     * @return 全局回话token
     */
    String createGlobalToken(String userId, Integer ttl);

    /**
     * 根据id获取用户
     *
     * @param userId 用户id
     * @return 用户对象
     */
    User getUser(String userId);

    /**
     * 根据id获取角色
     *
     * @param roleId 角色id
     * @return 角色对象
     */
    Role getRole(String roleId);

    /**
     * 获取用户的角色列表
     *
     * @param userId 用户id
     * @return 角色set集合
     */
    Set<Role> getUserRoles(String userId);
}
