/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Constants.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.core.attr.AbstractJSONAttrable;
import com.google.common.collect.Sets;
import cn.gtmap.egovplat.security.impl.SimpleRole;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-9-26
 */
public final class Constants {
    public static final String TOKEN = "hp_t";
    public static final String IP = "__ip";

    public static final String EVERYONE = "everyone";
    public static final String ADMIN = "admin";

    public static final Role ROLE_EVERYONE = new SimpleRole("1", EVERYONE);
    public static final Role ROLE_ADMIN = new SimpleRole("2", ADMIN);

    public static final String USER_ADMIN_ID = "0";


}
