/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DefaultRole.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.model.identity;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;
import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.core.bean.DictItemable;
import cn.gtmap.egovplat.core.entity.BaseEntity;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
@Entity
@Table(name = "pf_role")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Resource(key = "Role", name = "角色")
public class Role extends BaseEntity implements cn.gtmap.egovplat.security.Role, Comparable<Role> {
    private static final long serialVersionUID = 1482026265347925256L;

    public static final int TYPE_CONSTANT_NOUSER = -2;  //内置类型,不可以定义用户
    public static final int TYPE_CONSTANT = -1;  //内置类型,可以定义用户
    public static final int TYPE_NORMAL = 0;    //自定义角色
    public static final int TYPE_USER = 1;    //用户角色
    public static final int TYPE_DEPARTMENT = 2; //部门角色

    @Column(precision = 1, nullable = false)
    @Field("角色类型")
    private int type;
    @Column(length = 256, nullable = false)
    @NaturalId
    @Field("名称")
    private String name;
    @Column(length = 256)
    @Field("别名")
    private String title;
    @Column(length = 1024)
    @Field("说明")
    private String description;

    @ManyToMany(mappedBy = "roles")
    @Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private Set<User> users = Sets.newHashSet();

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JSONField(serialize = false)
    public Set<User> getUsers() {
        return users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public boolean isConstant() {
        return type == TYPE_CONSTANT;
    }

    @Override
    @JSONField(serialize = false)
    public String getKey() {
        return name;
    }

    @Override
    public int compareTo(Role o) {
        return o.getId().compareTo(getId());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Role && name.equals(((Role) obj).name);
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return "Role [" + getId() + "," + name + "]";
    }
}
