/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     PrivilegeAclKey.java
 * Modifier: yangxin
 * Modified: 2013-06-14 10:30
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.model.auth;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-31
 */
@MappedSuperclass
public class PrivilegeKey implements Serializable {
    private static final long serialVersionUID = 4680590785889918655L;
    @Id
    @Column(length = 32)
    private String roleId;
    @Id
    @Column(length = 32)
    private String nodeId;

    @Transient
    private Integer hash;

    public PrivilegeKey() {
    }

    public PrivilegeKey(String roleId, String nodeId) {
        this.roleId = roleId;
        this.nodeId = nodeId;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public int hashCode() {
        if (hash == null) {
            hash = 13;
            hash = hash * 37 + roleId.hashCode();
            hash = hash * 37 + nodeId.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PrivilegeKey) {
            PrivilegeKey other = (PrivilegeKey) obj;
            return roleId.equals(other.getRoleId()) && nodeId.equals(other.getNodeId());
        }
        return false;
    }
}
