/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     PrivilegeAcl.java
 * Modifier: yangxin
 * Modified: 2013-06-14 10:30
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.model.auth;

import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.security.Operation;
import org.apache.commons.lang3.builder.ToStringBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-31
 */
@Entity
@IdClass(PrivilegeKey.class)
@Table(name = "pf_privilege")
@Resource(key = "Privilege", name = "授权项")
public class Privilege extends PrivilegeKey implements Serializable {
    private static final long serialVersionUID = 4680590785889918655L;
    @Column(nullable = false)
    private long operation;

    /**
     * @see cn.gtmap.egovplat.model.metadata.Constants.NODE_TYPE_RESOURCE
     * @see cn.gtmap.egovplat.model.metadata.Constants.NODE_TYPE_INTERFACE
     */
    @Column(precision = 3, nullable = false)
    private int nodeType;

    public Privilege(String roleId, String nodeId, int nodeType, Collection<Operation> operations) {
        super(roleId, nodeId);
        this.operation = Operation.toCode(operations);
        this.nodeType = nodeType;
    }

    public Privilege(String roleId, String nodeId, int nodeType, Operation... operations) {
        this(roleId, nodeId, nodeType, Arrays.asList(operations));
    }

    public Privilege(String roleId, String nodeId, int nodeType, long operation) {
        super(roleId, nodeId);
        this.operation = operation;
        this.nodeType = nodeType;
    }

    public Privilege() {
    }

    public long getOperation() {
        return operation;
    }

    public void setOperation(long operation) {
        this.operation = operation;
    }

    public int getNodeType() {
        return nodeType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public List<Operation> getOperations() {
        return Operation.getOperations(getOperation());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
