/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     BaseController.java
 * Modifier: yangxin
 * Modified: 2014-07-01 21:58
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.web;

import cn.gtmap.egovplat.core.i18n.NLS;
import com.google.common.collect.Maps;
import cn.gtmap.egovplat.core.util.ExUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.Collections;
import java.util.Map;

import static cn.gtmap.egovplat.core.web.Vars.MSG;
import static cn.gtmap.egovplat.core.web.Vars.RET;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-1
 */
@Controller
public abstract class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    protected final String getMsg(String key) {
        return NLS.get(key);
    }

    protected final String getMsg(String key, Object... args) {
        return NLS.get(key, args);
    }

    protected static void success(RedirectAttributes ra, String msg) {
        ra.addFlashAttribute(RET, true);
        ra.addFlashAttribute(MSG, msg);
    }

    protected static void success(RedirectAttributes ra) {
        ra.addFlashAttribute(RET, true);
    }

    protected static void fail(Model model, String msg) {
        model.addAttribute(RET, false);
        model.addAttribute(MSG, msg);
    }

    protected static void fail(Model model, Exception ex) {
        model.addAttribute(RET, false);
        model.addAttribute(MSG, ex.getMessage());
    }

    protected static void fail(Model model) {
        model.addAttribute(RET, false);
    }

    @SuppressWarnings("unchecked")
    protected static Map<String, Object> success() {
        return (Map) Collections.singletonMap(RET, true);
    }

    protected static Map<String, Object> fail(String message) {
        Map<String, Object> map = Maps.newHashMapWithExpectedSize(2);
        map.put(RET, false);
        map.put(MSG, message);
        return map;
    }

    protected static Map<String, Object> fail(Exception ex) {
        return ExUtils.toMap(ex);
    }
}
