/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     BaseApiController.java
 * Modifier: yangxin
 * Modified: 2014-07-01 22:23
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.web;

import cn.gtmap.egovplat.core.util.ExUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-1
 */
public abstract class BaseApiController extends BaseController {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @ExceptionHandler(Throwable.class)
    @ResponseBody
    public Map<String, Object> handleException(Exception ex, HttpServletRequest request) {
        logger.debug("handle exception from request [" + request.getRequestURI() + "]", ex);
        return ExUtils.toMap(ex);
    }
}
