/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     AppExceptionTranslator.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.validation.interceptor;

import cn.gtmap.egovplat.core.validation.ValidationException;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.context.*;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.exception.OValException;
import net.sf.oval.internal.Log;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-29
 */
public class AppExceptionTranslator implements ExceptionTranslator {

    private static final Log LOG = Log.getLog(AppExceptionTranslator.class);

    @Override
    public RuntimeException translateException(OValException ex) {
        if (ex instanceof ConstraintsViolatedException) {
            ConstraintsViolatedException cex = (ConstraintsViolatedException) ex;
            ConstraintViolation cv = cex.getConstraintViolations()[0];
            String key = cv.getCheckName();
            OValContext ctx = cv.getContext();
            if (ctx instanceof FieldContext) {
                Field field = ((FieldContext) ctx).getField();
                key = StringUtils.uncapitalize(field.getDeclaringClass().getSimpleName()) + "." + field.getName();
            } else if (ctx instanceof ConstructorParameterContext) {
                key = ((ConstructorParameterContext) ctx).getParameterName();
            } else if (ctx instanceof MethodParameterContext) {
                key = ((MethodParameterContext) ctx).getParameterName();
            } else if (ctx instanceof MethodReturnValueContext) {
                key = ((MethodReturnValueContext) ctx).getMethod().getName();
            }
            LOG.info("Validation Exception ctx: {1} error: {2}", ctx, ex);
            return new ValidationException(key, cv.getMessage(), ex, getVariables(cv.getMessageVariables()));
        }
        return new ValidationException(ex.getMessage(), ex.getCause());
    }

    private String[] getVariables(Map<String, ?> args) {
        if (args == null) {
            return new String[0];
        } else {
            String[] arr = new String[args.size()];
            int i = 0;
            for (Object value : args.values()) {
                arr[i++] = String.valueOf(value);
            }
            return arr;
        }
    }
}
