/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Validator.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.validation;

import net.sf.oval.configuration.Configurer;
import net.sf.oval.guard.Guard;
import net.sf.oval.internal.ClassChecks;

import java.lang.reflect.Method;
import java.util.Collection;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-29
 */
public class Validator extends Guard {

    public Validator() {
        super();
    }

    public Validator(Collection<Configurer> configurers) {
        super(configurers);
    }

    public Validator(Configurer... configurers) {
        super(configurers);
    }

    public boolean needValidate(Method method, Class<?> targetClass) {
        ClassChecks cc = getClassChecks(targetClass);
        return cc.checksForMethodParameters.containsKey(method) ||
                cc.checksForMethodReturnValues.containsKey(method) ||
                cc.checksForMethodsPreExecution.containsKey(method) ||
                cc.checksForMethodsPostExcecution.containsKey(method);
    }
}
