/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ValidationException.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.validation;


import cn.gtmap.egovplat.core.i18n.NLS;
import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.util.ArrayUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-29
 */
public class ValidationException extends AppException {
    private static final long serialVersionUID = 1003756154232765865L;
    private String key;
    private String validationMessage;

    public ValidationException(String key, String validationMessage, Throwable cause, Object... args) {
        super(null, cause, VALIDATION_EX, args);
        this.key = key;
        this.validationMessage = validationMessage;
    }

    public ValidationException(String key, String validationMessage, Object... args) {
        this(key, validationMessage, null, args);
    }

    public ValidationException(String validationMessage, Throwable cause) {
        this("", validationMessage, cause);
    }

    public String getKey() {
        return key;
    }

    public String getValidationMessage() {
        return validationMessage;
    }

    public String[] getVariables() {
        Object[] args = getArgs();
        if (args == null) {
            return new String[0];
        } else {
            String[] arr = new String[args.length];
            for (int i = 0, len = args.length; i < len; i++) {
                arr[i] = String.valueOf(args[i]);
            }
            return arr;
        }
    }

    @Override
    public String getMessage() {
        Object[] args = getArgs();
        if (args == null) {
            args = new Object[]{key};
        } else {
            args = ArrayUtils.add(args, 0, key);
        }
        return key + " " + NLS.get(validationMessage, args);
    }
}
