/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Pair.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.util;

import com.google.common.base.Objects;

import java.io.Serializable;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-4-15
 */
public final class Pair<K, V> implements Map.Entry<K, V>, Serializable {
    private static final long serialVersionUID = -4360676587188395848L;
    private final K key;
    private final V value;
    private int hash;

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return key;
    }

    @Override
    public V getValue() {
        return value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    public static <K, V> Pair<K, V> pair(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    @Override
    public int hashCode() {
        if (hash == 0) {
            hash = 17;
            if (key != null) {
                hash = key.hashCode();
            }
            if (value != null) {
                hash = 37 * hash + value.hashCode();
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair p0 = (Pair) obj;
        return Objects.equal(key, p0.getKey()) && Objects.equal(value, p0.getValue());
    }

    @Override
    public String toString() {
        return "[" + key + ":" + value + "]";
    }
}
