/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     IO.java
 * Modifier: yangxin
 * Modified: 2014-06-11 15:31
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.util;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import java.io.*;
import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-11
 */
public final class IO extends IOUtils {
    private static final int TRANSFER_SIZE = 64 * 1024;

    public static Properties readProperties(InputStream is) throws IOException {
        return PropertiesLoaderUtils.loadProperties(new EncodedResource(new InputStreamResource(is), Charsets.UTF8));
    }

    public static Properties readProperties(File file) throws IOException {
        return PropertiesLoaderUtils.loadProperties(new EncodedResource(new FileSystemResource(file), Charsets.UTF8));
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int count = 0;
        try {
            byte[] buffer = new byte[TRANSFER_SIZE];
            int readed;
            while ((readed = in.read(buffer)) != -1) {
                out.write(buffer, 0, readed);
                count += readed;
            }
            out.flush();
        } finally {
            try {
                in.close();
            } catch (IOException ignored) {
            }
            try {
                out.close();
            } catch (IOException ignored) {
            }
        }
        return count;
    }

    private IO() {
    }
}
