/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ArrayUtils.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-5-9
 */
public final class ArrayUtils extends org.apache.commons.lang3.ArrayUtils {

    public static String[] subarray(String[] array, int startIndex) {
        if (array == null) {
            return EMPTY_STRING_ARRAY;
        } else if (startIndex <= 0) {
            return array;
        }
        int newSize = array.length - startIndex;
        if (newSize <= 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] subArray = new String[newSize];
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    @SuppressWarnings("unchecked")
    public static <T> T[] subarray(T[] array, int startIndex) {
        if (array == null) {
            return (T[]) EMPTY_OBJECT_ARRAY;
        } else if (startIndex <= 0) {
            return array;
        }
        int newSize = array.length - startIndex;
        if (newSize <= 0) {
            return (T[]) EMPTY_OBJECT_ARRAY;
        }
        Class<?> type = array.getClass().getComponentType();
        T[] subArray = (T[]) Array.newInstance(type, newSize);
        System.arraycopy(array, startIndex, subArray, 0, newSize);
        return subArray;
    }

    public static <T> List<T> asList(T... a) {
        return a == null ? Collections.<T>emptyList() : Arrays.asList(a);
    }

    private ArrayUtils() {
    }
}
