/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     WroConfigurationFactory.java
 * Modifier: yangxin
 * Modified: 2014-06-30 11:45
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.wro;

import cn.gtmap.egovplat.core.env.Env;
import org.springframework.beans.factory.InitializingBean;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.ConfigConstants;
import ro.isdc.wro.config.support.PropertiesFactory;

import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-30
 */
public class WroConfigurationFactory extends PropertyWroConfigurationFactory implements PropertiesFactory, InitializingBean {
    private final Properties properties;

    public WroConfigurationFactory(Properties props) {
        super(props);
        properties = props;
    }

    @Override
    public Properties createProperties() {
        return properties;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (Env.isProd()) {
            properties.put(ConfigConstants.debug.name(), "false");
            properties.put(ConfigConstants.resourceWatcherUpdatePeriod.name(), "0");
        }
    }
}
