/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     FriendlyExceptionInterceptor.java
 * Modifier: yangxin
 * Modified: 2014-07-02 13:29
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.spring;

import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import cn.gtmap.egovplat.core.util.ExUtils;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.support.RequestContextUtils;

import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-2
 */
public class FriendlyExceptionRenderInterceptor extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FriendlyExceptionRenderInterceptor.class);
    private String devView = "common/ex";
    private String prodView = "common/error";
    private List<SourceExtractor> sourceExtractors;
    private ViewResolver viewResolver;

    public void setDevView(String devView) {
        this.devView = devView;
    }

    public void setProdView(String prodView) {
        this.prodView = prodView;
    }

    public void setSourceExtractors(List<SourceExtractor> sourceExtractors) {
        this.sourceExtractors = sourceExtractors;
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null && !response.isCommitted()) {
            if (response instanceof ServletResponseWrapper) {
                response = (HttpServletResponse) ((ServletResponseWrapper) response).getResponse();
            }
            response.resetBuffer();
            Map<String, Object> model = Maps.newHashMap();
            AppException appEx = ExUtils.wrap(ex);
            model.put("type", ex.getClass());
            model.put("rawEx", ex);
            model.put("ex", appEx);
            if (Env.isDev()) {
                model.put("source", ExUtils.extractSource(sourceExtractors, ex));
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Handler execution exception [" + handler + "],id=" + appEx.getId(), appEx);
            }
            viewResolver.resolveViewName(Env.isDev() ? devView : prodView, RequestContextUtils.getLocale(request)).render(model, request, response);
        }
    }
}
