/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     DataPageableHandlerMethodArgumentResolver.java
 * Modifier: yangxin
 * Modified: 2014-06-13 22:18
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.spring;

import cn.gtmap.egovplat.core.data.P;
import cn.gtmap.egovplat.core.data.PageDefault;
import cn.gtmap.egovplat.core.data.Pageable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-13
 */
public class DataPageableHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return Pageable.class.equals(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Integer size;
        Integer offset;
        Integer index;
        PageDefault def = parameter.getParameterAnnotation(PageDefault.class);
        if (def != null) {
            size = getParam(webRequest, "size", def.prefix(), def.value());
            offset = getParam(webRequest, "offset", def.prefix(), def.offset());
            index = getParam(webRequest, "index", def.prefix(), def.index());
        } else {
            size = getParam(webRequest, "size", null, null);
            offset = getParam(webRequest, "offset", null, null);
            index = getParam(webRequest, "index", null, null);
        }
        if (size == null && offset == null && index == null) {
            return P.DEFAULT;
        } else {
            if (size == null) {
                size = Pageable.SIZE_DEFAULT;
            }
            if (index != null) {
                return P.index(index == 0 ? 1 : index, size);
            }
            if (offset == null) {
                offset = Pageable.OFFSET_FIRST;
            }
            return P.offset(offset, size);
        }
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty(prefix) ? name : prefix + "_" + name);
        return StringUtils.isNoneEmpty(s) ? Integer.valueOf(s) : def;
    }
}
