/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     SiteMeshFilter.java
 * Modifier: yangxin
 * Modified: 2014-06-28 08:59
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.egovplat.core.support.sitemesh;

import cn.gtmap.egovplat.core.util.RequestUtils;
import org.sitemesh.config.ConfigurableSiteMeshFilter;
import org.springframework.util.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-28
 */
public class SiteMeshFilter extends ConfigurableSiteMeshFilter {
    public static final String ALONE = "alone";
    private String excludeParam = ALONE;
    private String[] excludes;
    private String[] includes;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        excludeParam = filterConfig.getInitParameter("excludeParam");
        if (excludeParam == null) {
            excludeParam = ALONE;
        }
        excludes = StringUtils.delimitedListToStringArray(filterConfig.getInitParameter("excludes"), ",", " \n\r\t");
        includes = StringUtils.delimitedListToStringArray(filterConfig.getInitParameter("includes"), ",", " \n\r\t");
        super.init(filterConfig);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hsr = (HttpServletRequest) request;
        if (request.getParameter(excludeParam) == null && !RequestUtils.matchAny(hsr, RequestUtils.URL_PATH_HELPER, RequestUtils.PATH_MATCHER, excludes) && (includes.length == 0 || RequestUtils.matchAny(hsr, RequestUtils.URL_PATH_HELPER, RequestUtils.PATH_MATCHER, includes))) {
            super.doFilter(request, response, chain);
            return;
        }
        chain.doFilter(request, response);
    }
}
