/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     ContentPropertyTemplateModel.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.egovplat.core.support.sitemesh;

import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import org.apache.commons.lang3.StringUtils;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentChunk;
import org.sitemesh.content.ContentProperty;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-9-7
 */
public class ContentPropertyTemplateModel implements TemplateHashModel, TemplateScalarModel {

    private ContentProperty contentProperty;
    private ContentChunk data;

    public ContentPropertyTemplateModel(ContentProperty contentProperty) {
        this.contentProperty = contentProperty;
    }

    public ContentPropertyTemplateModel(Content content) {
        this.contentProperty = content.getExtractedProperties();
        this.data = content.getData();
    }

    public TemplateModel get(String key) throws TemplateModelException {
        return new ContentPropertyTemplateModel(contentProperty.getChild(key));
    }

    public boolean isEmpty() throws TemplateModelException {
        return contentProperty.hasChildren();
    }

    public String getAsString() throws TemplateModelException {
        return StringUtils.defaultString(data != null ? data.getValue() : contentProperty.getValue());
    }
}
